/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visualization;

import dev.engine_room.flywheel.api.visual.EntityVisual;
import dev.engine_room.flywheel.api.visualization.EntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.Nullable;

public final class SimpleEntityVisualizer<T extends class_1297>
implements EntityVisualizer<T> {
    private final Factory<T> visualFactory;
    private final Predicate<T> skipVanillaRender;

    public SimpleEntityVisualizer(Factory<T> visualFactory, Predicate<T> skipVanillaRender) {
        this.visualFactory = visualFactory;
        this.skipVanillaRender = skipVanillaRender;
    }

    @Override
    public EntityVisual<? super T> createVisual(VisualizationContext ctx, T entity, float partialTick) {
        return this.visualFactory.create(ctx, entity, partialTick);
    }

    @Override
    public boolean skipVanillaRender(T entity) {
        return this.skipVanillaRender.test(entity);
    }

    public static <T extends class_1297> Builder<T> builder(class_1299<T> type) {
        return new Builder<T>(type);
    }

    @FunctionalInterface
    public static interface Factory<T extends class_1297> {
        public EntityVisual<? super T> create(VisualizationContext var1, T var2, float var3);
    }

    public static final class Builder<T extends class_1297> {
        private final class_1299<T> type;
        @Nullable
        private Factory<T> visualFactory;
        @Nullable
        private Predicate<T> skipVanillaRender;

        public Builder(class_1299<T> type) {
            this.type = type;
        }

        public Builder<T> factory(Factory<T> visualFactory) {
            this.visualFactory = visualFactory;
            return this;
        }

        public Builder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
            this.skipVanillaRender = skipVanillaRender;
            return this;
        }

        public Builder<T> neverSkipVanillaRender() {
            this.skipVanillaRender = entity -> false;
            return this;
        }

        public SimpleEntityVisualizer<T> apply() {
            Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
            if (this.skipVanillaRender == null) {
                this.skipVanillaRender = entity -> true;
            }
            SimpleEntityVisualizer<T> visualizer = new SimpleEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
            VisualizerRegistry.setVisualizer(this.type, visualizer);
            return visualizer;
        }
    }
}

